---
type: axiom
tags:
  - "#layer/translation"
  - "#status/stable"
  - "#function/definition"
polarity: P+
aliases:
  - I1
  - Selective Permeability
  - Interface Discrimination
---

# I1 — Selective Permeability (axiom)

> **Interfaces must discriminate between flows** — not all differences can cross every boundary.

---

## Primitive Derivation

I1 emerges from how the structural primitives operate in the interface domain:

**From ∆ (Difference):** Interface formation begins with difference detection
- $∆_{interface}$ = distinction between "inside" and "outside" 
- This creates the fundamental discrimination capacity

**From R(·) (Relational Embedding):** Context determines what can cross
- $R(∆_{interface})$ embeds boundary differences in relational context
- Context shapes which flows are compatible with interface structure

**From ⊚ (Stabilization):** Discrimination patterns must close coherently
- $⊚(R(∆_{interface}))$ = stable discrimination function
- Closure requirement forces consistent selection criteria

**From F (Form):** Interface identity requires persistent discrimination
- $F_{interface}$ = discriminating boundary that maintains its character
- Form stability depends on reliable selective permeability

## Statement

For any interface I and flows F₁, F₂, the interface's discriminating Form requires:
- $F_I = ⊚(R(∆_{interface}))$ where $∆_{interface}$ distinguishes inside/outside
- $R(∆_{interface})$ provides relational context for flow compatibility  
- $⊚$ ensures discrimination closure: similar contexts → similar decisions
- The resulting Form maintains consistent selective permeability

---

## Dual‑register mapping

### Technical (network/computational)

| Axiom concept | Network construct | Interface example |
|---------------|------------------|-------------------|
| Discrimination | Flow filtering | `PacketFilter`, `Firewall` |
| Permeability | Access control | `ACL`, `Permissions` |
| Selection | Routing logic | `LoadBalancer`, `Router` |

### Humane (biological/relational)

| Axiom concept | Humane construct | Example |
|---------------|------------------|---------|
| Discrimination | Selective trust | "I choose who to let in" |
| Permeability | Boundary wisdom | "Some things belong, others don't" |
| Selection | Recognition | "I know what's mine" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Filter | Choice | What passes through |
| Access control | Trust boundary | Who gets in |
| Routing | Recognition | Where things go |

---

## Interface Primitive Mapping

| Primitive | I1 Application | Control Mechanism |
|-----------|----------------|-------------------|
| Port | Flow discrimination | τ_port selectivity |
| Gate | Threshold discrimination | τ_gate sensitivity |
| Surface | Exposure discrimination | α_permeability control |
| Buffer | Retention discrimination | γ_retention selectivity |

---

## Domain Manifestations

| Domain | Technical manifestation | Humane manifestation |
|--------|------------------------|---------------------|
| Physics | Field coupling selectivity | Natural resonance |
| Chemistry | Reaction selectivity | Chemical affinity |
| Biology | Membrane selectivity | Living boundaries |
| Social | Trust boundaries | Relationship choice |
| Economy | Market segmentation | Value recognition |
| Politics | Legal boundaries | Power discrimination |
| Networks | Protocol selectivity | System boundaries |
| Cognition | Attention selectivity | Mental filtering |

---

## Stability Requirements

- **Discrimination Consistency:** Similar flows receive similar treatment
- **Boundary Integrity:** Selection criteria remain stable over time
- **Control Responsiveness:** Discrimination adapts to λV modulation

---

## Dependencies & scope

- Dependent on: Core axioms A1-A3 (derives from their application to interfaces)
- Independent of: Other interface axioms I2, I3 (foundational peer)
- Applies to: Interface primitives (Port, Gate, Surface, Buffer)
- Domain scope: All interface operations requiring discrimination

---

## Implications / derivations (selected)

- Enables Port selectivity mechanisms
- Enables Gate threshold evaluation  
- Enables Surface exposure control
- Enables Buffer retention discrimination
- Forms foundation for interface control modulators (τ_port, τ_gate)

---

## Related structures

- Primitives: [[Port]] · [[Gate]] · [[Surface]] · [[Buffer]]
- Constants: [[λV — Void Resonance Threshold (Volozhina)]] (primary modulator)
- Modulators: τ_port, τ_gate, α_permeability
- Core Axioms: [[A1 — Irreducibility (axiom)]], [[A2 — Asymmetry (axiom)]]

---

## Design rationale

This axiom ensures that interfaces maintain their essential function of controlled exchange while respecting the dual-register principle that technical precision and humane understanding are both necessary.

---

## See Also

- [[I2 — Boundary Integrity (axiom)]]
- [[I3 — Flow Conservation (axiom)]]
- [[00.0.1.0 - Interface Axioms (index)]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
